Attribute VB_Name = "mdDrawNote"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to create a note

Function DrawNote(Design, drawdoc, graph)

Rem To get the global application object
GetApplicationObject

'Get the Drawing Object pointer
Dim draw As aDrawing
Set draw = drawdoc.GetDrawing

Dim ddetail As aDesignDetail
Set ddetail = draw.GetDetail(Design, False)

'get the paper geometry of selected item
Dim geom As zGeometry
Set geom = drawdoc.GetPaperGeometry(graph)

'Creating Note
Dim tolerance2 As aNote
Set tolerance2 = app.GetClass("Note").CreateNote(draw, "My Note")
Dim callout2 As aNoteCallout
Set callout2 = app.GetClass("NoteCallout").CreateNoteCallout(tolerance2)

tolerance2.SetText ("New Note")

'Set the position for the dimension line
Dim textLocation2 As ZVector
Set textLocation2 = app.GetClass("Vector").CreateVector(0.1, 0.2, 0)

Dim calloutgroup2 As aCalloutGroup
'0.005 is the text height
Set calloutgroup2 = app.GetClass("CalloutGroup").CreateCalloutGroup(callout2, textLocation2, 0.005)
calloutgroup2.SetControlPoint 1, textLocation2
callout2.SetBoxed (True)
draw.AddCalloutGroup calloutgroup2

'create feature leader
Dim leader2 As aLeader
Set leader2 = app.GetClass("FeatureLeader").CreateFeatureLeader(calloutgroup2, geom)
draw.AddLeader leader2

'Add CenterLine
'To be done



End Function
